# 第六章 开源教育现状

开源教育旨在让数字时代的公民了解开源的理念与文化，增强数字化协作能力，共享开源开放的成果。开源教育由来已久，其本身具有的开放共享特性，与教育的目标和特征不谋而合。开源教育涵盖开源文化教育、开源意识教育、开源技能教育三方面。开源文化教育内容主要包括开源社区的形成机理和运转机制，以及开源活动得以持续生存和发展的机制、机理等，同时还包括开源历史、开源共识及开源的治理规则等。开源意识教育包括创新意识和开放透明的协作共享意识教育，创新意识表现在基于开源技术迭代的基础上，敏锐感知新兴技术的需求并进行快速创造，协作共享意识表现在适应全球分布式开发的趋势。开源技能教育体现为开发者传统的编程能力，开发者对开源技术和工具的使用能力，以及分布式环境下的协调、协作能力。

## 6.1 开源教育正加速融入并贯穿教育全阶段

### 6.1.1 高、中、小学开源教育

在人才培养的高、中、小学阶段，开源文化与技术逐渐渗入庞大的教学体系中。虽然中小学信息化教育目前较少开设独立的开源文化与技能教学内容模块，但是由于开源具有低成本、便于获取、学习和应用等优势，各地高、中、小学尝试以开源软件作为素质教育、创客教育的工具，培养学生的科学精神和创造力。众多开源组织和开源在线教育平台组织了相关师资培训及学生创客活动，进行开源启蒙教育。

### 6.1.2 高等院校开源教育

高等院校开源教育从学生、教师自发开源教育行为转变为院校行为，从高校教师的独立行为转变为与开源社区合作的共建行为。在高校推进开源教育，建立产学研一体化开源创新人才培养体系，对我国培养适应产业需求的高质量软件人才、建立可持续发展的开源生态、提升软件科技源头创新和软件技术的供给能力、实现向创新链高端跃升等方面具有重要意义。例如，北京大学软件与微电子学院的荆琦老师提出的“产教融合下的双轨制开源教学模式”，与DoKit&Hummer、OpenAnolis、OpenCloudOS、openEuler、openLooKeng、PostgreSQL、Apache、RocketMQ、长安链等开源社区合作，开源文化通识性教育和开源实践开发指导双轨同步进行，带给学生全方位、沉浸式的开源学习环境。课程通过与开源社区合作，解决了开源技术方向多样性与教师个人研究方向单一性之间的矛盾。而且课程在与社区合作的同时，也注重与开源项目捐献企业的校企合作，在一定程度上弥补了企业人才需求与高校教育之间的差距。

目前，国内很多高校已经在积极探索我国开源创新人才的培养路径，推动开源软件生态建设，提升软件人才与关键软件技术创新和供给能力。众多高等院校加大开源基础设施投入力度，进行开源课程建设，组织开源相关讲座、竞赛以及多种线上、线下活动。在高校教师授课中涉及开源的内容占比以及学科深度显著增加。

### 6.1.3 职业教育与终身教育

开源职业教育与终身教育跟随行业需求飞速发展。随着互联网技术的更迭，以及近年来开源具有越来越大的影响力，开源相关培训以及网络课程大量增加。基于网络的大规模开放在线课程MOOC学习模式出现，大量优质开源课程资源免费共享，吸引来自全球学习者注册学习，其中典型的代表是edX、Coursera、Udacity等MOOC平台。许多知名开源项目以及开源项目企业贡献者，为了推动相应技术的大规模应用，也开始组建专门的技术培训学院，发布相应培训认证课程，围绕开源项目推动专业化教育，如红帽推出了体系化的Linux认证课程等。GitHub、GitLink、CSDN、开源中国等开源社区上的优质项目也为学习者提供了面向全球顶级开发者学习实践的通道。

在国家相关政策的指导下，随着教育信息化的发展，开源教育正在融入从中小学教育到职业化教育的各个阶段。2022年3月，教育部举行国家智慧教育平台启动仪式。教育部党组书记、部长怀进鹏出席仪式并宣布“国家智慧教育平台”正式上线，强调要以平台开通为契机，紧紧抓住数字教育发展战略机遇，以高水平的教育信息化引领教育现代化。国家智慧教育平台为开源教育提供了重要推广和支撑环境。具体来看，该平台从五个方面支撑开源教育。

+ 要建立教育数字化公共服务体系。把国家智慧教育平台打造成提供公共服务的国家平台、学生学习交流的平台、教师教书育人的平台、学校办学治校与合作交流的平台，教育提质增效和改革发展的平台，以及实现个性化学习、终身学习和教育现代化的平台。
+ 要坚持优先服务师生和社会急需，支撑抗疫大局。为抗疫一线师生打造一所永远在线的网上课堂，加强抗疫知识学习、心理健康教育和引导，提供更加坚强有力的保障。
+ 要坚持自立自强，强化效果导向、服务至上，引领教育变革。运用平台深化“双减”，赋能职教，创新高校教育改革，深化评价改革，突出效果导向，推进应用服务支持。
+ 要坚持守正创新，加强体制、机制建设，推动共建、共享。汇聚众力、广集众智，为各方协同发展、共建共享数字社会创造契机。
+ 要坚持高水平开放合作，打造国家品牌。加强国际交流，探索数字治理方式，努力成为智慧教育的国际引领者。为世界提供中国方案，贡献中国智慧。

## 6.2 开源教育平台迅速发展

### 6.2.1 基于开发工具和知识社区的开源教育平台

基于开发工具的开源教育平台支持大规模开源开发者分享开源技术、传播开源理念、推广开源项目。基于开发工具的平台典型代表包括Github.com、SourceForge.net、GitLink.org.cn、Gitee.com、GitCode.net、learnerhub.net等。其中，GitHub平台于2008年4月10日正式上线，除了Git代码仓库托管及基本的Web管理界面以外，还提供了订阅、讨论组、文本渲染、在线文件编辑器、协作图谱（报表）、代码片段分享（Gist）等功能。Gitee（码云）是开源中国于2013年推出的基于Git的代码托管和协作开发平台，提供本地化的代码托管服务。同时，Gitee也提供了开源软件的发布和沟通社区，供开发者在其中进行技术交流和沟通。

基于知识社区的开源教育平台提供了软件工程服务、讨论区、资源库等，形成了活跃的互动在线学习模式。平台典型代表包括Stackoverflow.com、CSDN.net、learnerhub.net等。其中，Stack Overflow由Jeff Atwood和Joel Spolsky这两位非常著名的Blogger在2008年创建，旨在提供一个与程序相关的IT技术问答网站。中国专业IT社区CSDN (Chinese Software Developer Network) 创立于1999年，致力于为中国软件开发者提供知识传播、在线学习、职业发展等全生命周期服务。

### 6.2.2 基于开放实践和开源竞赛的开源教育平台

基于开放实践和开源竞赛的开源教育平台支持大规模开源开发者参与开源项目实训，该类平台以实践需要为导向，形成了产教一体化的在线学习模式。例如，早期国防科技大学毛新军教授团队基于社交化编程思想和群智共创理念，设计了群体化学习平台原型系统（learnerhub.net），其主体包括群体化学习内容共创、群体化学习主题研讨、群体化学习问题解决、群体化教学过程外包四大部分，用以支撑开源活动和进行开源教育。

头歌（educoder.net）是一个由国内知名高校、产业联盟和大型企业共同发起的新型开放在线实践教学平台。基于大规模开放在线实践（MOOP）范式，头歌将1000多种开源软件引入教研和教学活动，支持2500所高校建立的4000多门在线实践课程，涵盖计算机程序设计、软件工程、计算机系统、云计算、大数据、人工智能、电子技术、智能制造等几乎所有专业方向的教学、实验、实训和科研活动，同时也支持老师和开发者按需协同开发在线实践项目和课程，为各类高校和社会各界提供高可扩展和高可定制的教学资源和实践环境。

CSDN在20余年的发展中，逐步建成了体系化、多视角的教育平台。由优秀博主设计的专栏和课程在IT行业各个领域都有覆盖。由CSDN和专家主导的技能树、编程比赛、专项训练为IT人士提供了循序渐进、自我驱动的培养体系。与此同时，CSDN联合企业提供项目实习、各领域认证考试、企业招生支持，以及派遣服务，为企业提供最需要、高匹配的人才。 

CSDN推出的训练平台和能力认证，致力训练开发者的硬核技能，整体设计融入“技术素养”“项目素养”“开源素养”和“职业素养”。广大在校生可以通过训练平台进行技能实训，从而提升工程化交付能力。平台设计以任务闯关为驱动，培养主动学习的习惯，现已培养了大量具备动手能力的IT研发工程师。能力鉴定方面，CSDN能力认证以真实项目为考题，采用真实场景（全程录屏、真人露脸）的考核方式，线上实时监考，所有代码与文档同步到GitCode。效果评估方面，有专家评判结果，有据可查。通过CSDN的训练平台和能力认证，为IT大学生毕业上岗缺乏实践经验及软件工程师技术能力客观评估提供了有效的解决路径。

百度AI Studio是针对AI学习者的在线一体化学习与实训社区，集合了AI教程、深度学习样例工程、各领域的经典数据集、云端的超强运算及存储资源，以及比赛平台和社区。从而解决学习者在AI学习过程中的一系列难题，例如教程水平不一、教程和样例代码难以衔接、高质量的数据集不易获得，以及本地难以使用大体量数据集进行模型训练等。

竞赛类学习平台主要采用在线编程竞赛的形式促进学习者进行程序设计语言学习、算法设计、编程应用等。例如，Topcoder平台（topcoder.com）每个月都有2~3次在线编程比赛，参赛者可根据自己的爱好选用Java、C++、C#、VB或 Python进行编程。Kaggle平台（kaggle.com）为学习者提供了举办机器学习竞赛、托管数据库、编写和分享代码的环境，近些年吸引了大量学习者的关注。头歌将全栈化智能在线实践技术和环境引入在线竞赛，有效支持在线实战化的全流程竞赛和活动。

自2018年以来，中国软件开源创新大赛已成功举办四届。为激发开源创新活力，培养开源软件人才，助力开源生态建设，探索开源教育改革，在教育部高等学校计算机类专业教学指导委员会和软件工程专业教学指导委员会的推动和支持下，在国家自然科学基金委员会信息科学部的指导下，2022年由中国计算机学会（CCF）主办第五届“中国软件开源创新大赛”。大赛重点围绕国家在开源人才培养和生态建设方面的重大战略需求，聚焦“卡脖子”软件领域以及人工智能、大数据等前沿技术领域的开源软件，联合华为、百度、清华大学等企业单位以及多所高校共同设置赛题。

## 6.3 国内高校发起的开源项目教育实践

近年来，我国高校不仅基于开源技术加速教学体系升级，也积极探索、大胆创新，发起了一批优秀的开源项目并有效用于教学和科研工作。下面结合国内三所高校的相关工作介绍该方向的最新动态。

### 6.3.1 清华大学IoTDB项目

如今，工业互联网已成为国际制造业竞争的制高点，也是中国制造业实现数字化转型的重要途径。为解决工业互联网领域的时间序列大数据管理需求，清华大学软件学院王建民教授带领团队自主研制了面向工业领域的开源时间序列数据管理系统Apache IoTDB。

围绕科研评价“去五唯”，清华大学软件学院从2018年起改革学生奖学金评选规则，在鼓励同学发表高水平、高影响力学术论文的同时，积极鼓励同学参与开源社区建设。从Apache IoTDB社区成长出来的黄向东博士、乔嘉林博士、田原硕士，先后获得了中国科协托举工程、国家奖学金和清华软件奖，极大地激发了同学们参加开源创新的热情。

在积极引导同学参加开源工作的同时，清华大学软件学院还鼓励教师积极参加开源工作，并将开源实践引入课程教学工作，比如在清华大学大数据证书人才培养项目中积极引导同学使用包括Apache IoTDB在内的工业大数据软件，结合企业应用项目开展“真刀真枪”的课程实践，每年有近百名来自清华大学二十多个专业的同学获益。

除了在科研教学实践中培养开源精神，清华大学软件学院还于2018年开始举办清华开源之道论坛，包括中国开源联盟秘书长、Apache基金会秘书长、国内外知名开源领域专家先后到清华讲授开源理念。软件学院积极走出去，在新疆大学、湖南科技大学等兄弟院校积极推广开源理念。同时，他们也启动了与“确实社区”的合作，基于IoTDB等开源项目开发开源课程。

通过开源实践，清华大学软件学院形成了以下经验和体会：

* 开源促进国际化人才培养。通过加入开源社区，唤醒利他精神，培养了一批掌握开源规则、具有全球视野的青年教师（托举计划）和优秀学生（国家奖学金）；
* 促进科研成果传播。“清华数为”IoTDB开源以后，不仅为国内大型工业龙头企业和工业互联网双跨平台所用，还在美国、德国、法国、日本、巴西等国家的企业中得到应用；
* 开源提升国际影响力。开源是全球性质的活动，开发者随着软件的传播进一步提升国际影响力，例如入选MIT德国科技论坛特别报道，并且相关科研论文被VLDB2020/FAST2022等顶级会议接受发表。

### 6.3.2 北京大学XiUOS项目

矽璓XiUOS（X Industrial Ubiquitous Operating System）是北京大学信息技术高等研究院泛在操作系统实验室开源发布的一款面向工业物联场景的泛在操作系统，其出现源自人机物融合计算和第四次工业革命产业需求的碰撞。

人机物融合计算被认为是继主机计算、个人计算、移动计算之后出现的新型计算模式，其万物数字化、交互网络化、系统智能化、计算泛在化等新特性要求新型操作系统的支撑。为此，北京大学梅宏教授团队联合国内多所高等院校、科研机构倡议发起泛在操作系统（Ubiquitous Operating Systems，UOS）研究计划，致力于研发支持互联网时代人机物融合计算模式的新型操作系统——泛在操作系统。

在泛在操作系统技术体系中，不同的应用场景需构建不同的UOS实例。矽璓XiUOS是面向工业物联网应用场景的一种UOS，支持工业物联网应用，帮助解决在车间内实施智能化生产面临的“全面感知、泛在互联、实时认知、精准调控”等问题，促进工业环境人机物的深度互联和融合计算，使能智能制造。

工业物联网是典型的人机物融合泛在计算场景，学术界和产业界对相关人才、工具和知识有高度需求，对从事相关学术研究的科研人员而言，其需要一个开放的工业物联网操作系统作为平台开展学术研究和实验验证，并沉淀相关技术成果；对众多数字化水平不一的工业企业而言，其迫切需要适合自身需求、简单易用的工业物联网操作系统帮助推进数字化转型和智能化升级，还需要众多具备工业物联网多学科相关知识和技能的专业开发人员。因此，矽璓XiUOS团队高度重视开源社区合作和开源教育工作，在GitLink开源平台和木兰开源社区上开放系统源码后，推出开源教育计划，开始编写工业物联网操作系统培训教材。基于头歌平台设计实验案例，并推出面向教学场景的轻量级智能工业物联终端，支持ARM和RISC-V架构处理器，可集成AI加速芯片，具有多种总线接口，支持LoRa/Wi-Fi协议，可开展各种工业环境人机物融合计算的感知、互联、认知、控制等实验。矽璓相关开源教育工作预期将为工业物联网领域培养大量专业人才。

### 6.3.3 浙江工业大学开源教育项目

浙江工业大学计算机科学与技术学院、软件学院陈铁明教授团队研发了DGIoT-Edu和Kellect两个开源项目，分别实现轻量级物联网安全接入与应用开发平台、系统内核层日志高性能采集与智能处理框架，并用于开源教育、科研实验和应用创新。

DGIoT-Edu是国内首款面向轻量级工业物联网安全接入与应用开发的开源平台。平台可进行一键式开发部署，实现海量物联设备的安全可控接入，并开放二次应用开发。支持物联模型—规则引擎—数据通道—组态页面全流程低代码开发、前后端完全开源、兼容多行业工业协议，千万级承载，运营级底座，全开放扩展，在降低开发运维成本的同时保障运营安全、设备安全、数据安全，支持物联网应用系统开发的全过程国产化，无“卡脖”之忧。

DGIoT-Edu在工业物联网安全接入与应用开发方面的开源教育模式分为教学课程、实验实训、应用实战三个部分：

* 教学课程：基于平台开展面向工业互联网产业需求的相关软硬件开发，主要开展工业互联网技术原理、物联网平台技术、传感器设备的介绍与使用、行业案例分析与开发等教学课程；
* 实验实训：面向实验教学和产业实训需求，收集物联网的行业应用案例，开发DGIoT-Edu开源实验案例库，让学生自主完成传感器的安全接入、应用开发、数据分析等实验；
* 应用实战基于DGIoT-Edu搭建轻量级物联网应用创新实验场，支持学生面向工业互联网业务场景快速复刻创新应用，扩展DGIoT-Edu的开源项目外延。

Kellect是一款高性能系统内核层日志无损采集与智能处理开源框架。框架可进行用户态和内核态的事件日志采集，解决海量日志采集慢、解析难、延时长等问题，并开放二次应用开发，可为用户行为检测、APT攻击检测、勒索病毒检测等安全应用工具开发提供核心技术支撑，并为安全科研与教学提供实验服务平台。

在安全应用与开发方面，Kellect分为教学课程、实验实训、研究创新三个部分：

* 教学课程：基于处理框架开展面向系统内核的日志事件数据采集和数据挖掘，主要开展系统内核运行机制、软件行为分析、安全应用案例与开发等教学课程，并出版了国内首本《数据安全》创新实践类教材。

* 实验实训：面向实验教学和产业实训需求，收集基于内核事件日志的安全应用案例，完善事件日志数据集合，让学生基于日志完成数据挖掘、模型训练、安全检测等实验。

* 研究创新：基于Kellect系统内核层日志智能处理框架，支持学生进行跨平台、跨层域内核日志数据采集，基于数据进行特征挖掘、行为提取、模型训练等科研创新，多篇论文已发表在TIFS、TDSC等安全领域顶级期刊。

## 6.4 探索多主体开源教育协同模式

虽然中国开源教育模式众多，但开源人才与市场的需求仍然有较大的差距。国外众多知名高校已经形成了科研、教材、案例、开源项目、企业应用等为一体的开源教育体系。在企业中，前沿科研成果以开源项目发布，学校围绕前沿技术编写教材和教学案例，依托开源项目开展实践教学，培养的人才对接企业需求。我国政府、高校、教育培训机构以及众多开源企业一直在摸索适合我国开源教育的道路，以企业为主导的“联盟”模式、政府联手的“1+1+1工程”、校企合作的双轨制模式、以校园为基础的“浙江模式”和综合推进的“广州经验”，都为开源教育奠定了基础，提供了宝贵的经验，然而尚难以满足行业庞大的需求。

### 6.4.1 开源教育由多主体承担

社区开源教育：以开源社区/开源基金会为依托，通过自觉或不自觉的方式推动的教育活动。Linux基金会、OpenStack基金会等为推广开源社区和开源技术，常态化地组织相应的开源治理交流、开源技术讨论、技术能力培训认证等。例如，开源人才培育中心红帽学院提供多样化的开源课程内容、灵活的实训教学环境、实际任务操作型认证考试和全球通用的标准化资料。

企业开源教育：大量企业构建了专门的开源团队持续投入开源项目的研发，同时也围绕开源技术组织大规模的教育培训、能力认证以及宣传推广等活动。例如，中标麒麟教育学院（由中标软件有限公司受国家Linux技术培训与推广中心的委托建立的信息技术人才培训基地）是目前中国最大的也是唯一的国产Linux操作系统厂商培训机构。它在各高校中建设了大数据实验室、可信计算实验室、安全攻防实验室和安全测评实验室，与高校共同增设专业方向，引入中标麒麟教育学院的优秀教学资源，实施“课堂教学+实战”相结合的教学模式，实现学历教育与职业教育的双重培养。

高校开源教育：欧洲和美国许多大学鼓励学生参与开源，我国高校也围绕将开源技术融入到人才培养，尤其是实践教学环节开展了有益的探索。例如在2005年，开源高校推进联盟（LUPA）在杭州成立，对我国开源人才培养起到了积极的推进作用。我国大部分高校很早就开设了讲授Linux等开源软件的课程，也有很多课程将开源软件作为教学示例，在讲授软件的同时传授开源开发技术。近年来，随着开源开放、协作创新理念的普及，讲授开源文化和相关领域知识的课程越来越多，开源布道进入高校，与开源实践类课程相结合，培养出越来越多高质量开源贡献者。

科研院所开源教育：众多科研院所和开源社区合作的深度与广度显著增加，除了开源协作开发之外，也积极推进开源教育。例如“开源供应链点亮计划”是由中科院软件所和openEuler社区共同举办的一项面向高校学生的暑期活动，旨在鼓励在校学生积极参与到开源软件的开发和维护中，促进国内优秀开源软件社区的蓬勃发展。

### 6.4.2 协同教育模式成为开源教育发展趋势

政府引导：2020年6月5日，教育部办公厅、工业和信息化部办公厅关于印发《特色化示范性软件学院建设指南（试行）》的通知中提出，要以特色化软件人才培养为目标，以深化产教融合为途径，以改革创新为驱动，以特色发展为重点，深化软件人才培养模式改革，大力开展关键核心软件技术攻关，促进软件生态体系建设，充分发挥软件人才培养对产业发展的支撑引领作用，推动我国软件产业实现由大到强的历史跨越。在指南的指导下，培育重点开源项目、汇聚优秀开源人才、建立创新型开源教育模式、培养高质量软件人才，成为当前高校开源教育的重点任务。同时，开源教育也在对接教育部“计算机领域本科教育教学改革试点工作计划（101计划）”。

高校、企业、社区、科研院所多方积极协同：随着开源教育从以开源软件教学为主的教育模式向理论与实践结合的综合教育模式的转变，高校、企业和开源社区、科研院所等多方协作、协同创新的教育模式不断被探索，共同培养开源人才的方式逐渐演变为未来发展趋势。一些企业与高校联动，形成校企联合建设实训基地。企业可为高校提供专业级实训平台、课程实践案例、业内导师，以及以横向课题的形式形成科研成果等，高校则不断为企业输送具有实践能力的专业人才。例如极狐（GitLab）免费向X-lab成员中的华东师范大学数据科学与工程学院师生提供极狐GitLab旗舰版使用许可。并且，X-lab实验室将极狐在开源文化、开源社区运营管理、DevOps等领域的通用知识纳入教材编写与人才培养计划。同时，X-lab利用极狐技术平台与开源社区资源，基于极狐GitLab平台研发“校园版”DevOps。

平台支持：2021年，中国计算机协会（CCF）开源发展委员会成立，作为中国计算机及相关领域具有广泛影响的学术团体，重点聚焦共同打造开源、开放、中立的产学研协同开源创新服务平台，通过培育原始开源创新项目，协同科教资源、产业资源和社会资源等探索产、教、研联动的开源创新模式，推动探索学术共同体主导的开源发展新途径，助力我国开源生态建设的发展。在OSTech、华为、Linux基金会亚太区、Linux基金会开源软件学院、南方科技大学等高校开源俱乐部及企业社区的联合支持下，成立了高校开源社区联合体——开源高校联盟，它提供社区运营、技术、课程/认证、导师以及多方面资源和资金服务。开源高校联盟面向全球高校，包括学生、教师、研究院等不同身份的开发者，宗旨是连接国际一流的开源基金会、企业和院校，融合多方开源技术和经验，汇聚为集开源知识与文化、技术培训与认证、职业成长、实习与就业创业的高校开源平台。

## 6.5 制约开源教育快速发展的瓶颈

开源产业生态高速发展，人才需求紧随其变化，为高校开源人才培养带来匹配难度。尽管企业、科研院所、社区等多个主体都在开展开源教育，培养开源人才。然而，高等院校仍处于人才培养机制的核心地位，但其对开源人才的培养规模体量尚小，难以支撑开源生态蓬勃发展的需要。虽然高等院校的信息类、计算机类、软件类专业教育对开源均有所涉及，但开源更多被视为工具，以开源文化、意识和相关技能为核心的教育力度不足。优秀国产开源成果的课程体系设计、师资队伍建设和培养计划制定尚待完善，以开源教育为核心的内容尚未被设置为普遍性的课程，将其纳入学分的高校数量有限。

多主体开源教育协同、融合机制仍在初级发展阶段，可持续协同模式尚未形成领先经验。无论是政府、产业界还是学术界，已就建立产学研一体化开源创新人才培养体系，从而解决矛盾上达成共识，然而系统性框架和可持续协同模式尚未形成成熟经验。教育部提出“计算机领域本科教育教学改革试点工作计划（101计划）”和“特色化示范性软件学院建设计划”。产学研各界正积极建立从高校开源学习、产业开源实践到开源创新创业的闭环，服务我国软件产业发展。

## 6.6 开源教育发展建议

在开源教育发展方面，2022年3月，全国人大代表、中国科学院院士、南京大学校长吕建在两会期间建议：

第一，推动基于优秀国产开源成果的课程体系设计、师资队伍建设和培养计划制定，培养开源创新人才，支撑国产开源软件形成可持续发展生态。前沿信息技术如云计算、大数据、人工智能、区块链等均以开源模式快速创新，高校相关课程体系要积极吸纳开源成果，推动基于开源的高校软件教育。一是鼓励高校和企业联合，围绕我国开源成果开发建设课程教材和实践能力教学体系，开设相应课程，通过必修课、学分制等推进课程普及。二是设计相应的激励政策和交流通道，鼓励企业开源人才进入高校课堂，建立良好的开源师资队伍。三是推动校企联合，开展产业开源生态链实习，引导学生进入国产开源软件生态，为形成可持续生态培养后备力量。建议由教育部牵头，会同工信部等国家部委，以101计划和特色化示范性软件学院建设为基础，推动基于开源的教育落实到相应方案和规划中。

第二，加强开源文化和开源技能教育，建立鼓励软件成果开源的评价机制和价值导向，推动高校产出更多原创性开源成果。高校是科技创新的重要源头，我国高校亟需加强面向开源的软件教育。一是在软件工程等相关课程内容设计上，主动融入开源文化、开源规律和开源模式的教学内容，培养学生的开源意识和开源技能。二是在高校学科建设评价机制方面，将成果开源情况纳入考核指标，鼓励高校师生积极参与开源社区贡献，鼓励高校形成原创性开源成果。建议由教育部牵头，会同科技部等国家部委，推动面向开源的软件教育课程内容改革以及教学科研评价机制设计。

第三，以开源教育为抓手，打造新型产教融合平台，建立从高校开源学习、产业开源实践到开源创新创业的闭环，服务我国软件产业发展。开源教育应拓展到人才培养成长的各个阶段，需要相应平台和政策环境的支持。一是以各类教学服务平台为基础，以开源实践创新为抓手，打造涵盖学习实践和创新创业的云原生产教融合开源实践平台和开放共享学习创业社区；二是以学生为中心，以融合平台为依托，联合高校、企业、投融资机构等建立起支持学生从开源实践到创新创业的机制和途径。建议由教育部联合工信部、国家发改委、中国科协等共同设计行动方案。
